/***************************************************************************
                         testqgslayoutmapoverview.cpp
                         ----------------------
    begin                : October 2017
    copyright            : (C) 2017 by Nyall Dawson
    email                : nyall dot dawson at gmail dot com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "qgsapplication.h"
#include "qgslayout.h"
#include "qgslayoutitemmap.h"
#include "qgslayoutitemmapoverview.h"
#include "qgsmultibandcolorrenderer.h"
#include "qgsproject.h"
#include "qgsrasterdataprovider.h"
#include "qgsrasterlayer.h"
#include "qgstest.h"

#include <QObject>

class TestQgsLayoutMapOverview : public QgsTest
{
    Q_OBJECT

  public:
    TestQgsLayoutMapOverview()
      : QgsTest( QStringLiteral( "Layout Map Overview Tests" ), QStringLiteral( "composer_mapoverview" ) ) {}

  private slots:
    void initTestCase();        // will be called before the first testfunction is executed.
    void cleanupTestCase();     // will be called after the last testfunction was executed.
    void init();                // will be called before each testfunction is executed.
    void cleanup();             // will be called after every testfunction.
    void overviewMap();         //test if overview map frame works
    void overviewMapRotated();  //test if overview map frame works with rotated overview
    void overviewMapRotated2(); //test if overview map frame works with rotated map
    void overviewMapBlending(); //test if blend modes with overview map frame works
    void overviewMapInvert();   //test if invert of overview map frame works
    void overviewMapCenter();   //test if centering of overview map frame works
    void overviewReprojected(); //test that overview frame is reprojected

  private:
    QgsRasterLayer *mRasterLayer = nullptr;
};

void TestQgsLayoutMapOverview::initTestCase()
{
  QgsApplication::init();
  QgsApplication::initQgis();

  //create maplayers from testdata and add to layer registry
  const QFileInfo rasterFileInfo( QStringLiteral( TEST_DATA_DIR ) + "/rgb256x256.png" );
  mRasterLayer = new QgsRasterLayer( rasterFileInfo.filePath(), rasterFileInfo.completeBaseName() );
  QgsMultiBandColorRenderer *rasterRenderer = new QgsMultiBandColorRenderer( mRasterLayer->dataProvider(), 1, 2, 3 );
  mRasterLayer->setRenderer( rasterRenderer );
}

void TestQgsLayoutMapOverview::cleanupTestCase()
{
  delete mRasterLayer;

  QgsApplication::exitQgis();
}

void TestQgsLayoutMapOverview::init()
{
}

void TestQgsLayoutMapOverview::cleanup()
{
}

void TestQgsLayoutMapOverview::overviewMap()
{
  QgsLayout l( QgsProject::instance() );
  l.initializeDefaults();
  QgsLayoutItemMap *map = new QgsLayoutItemMap( &l );
  map->attemptSetSceneRect( QRectF( 20, 20, 200, 100 ) );
  map->setFrameEnabled( true );
  map->setLayers( QList<QgsMapLayer *>() << mRasterLayer );
  l.addLayoutItem( map );

  QgsLayoutItemMap *overviewMap = new QgsLayoutItemMap( &l );
  overviewMap->attemptSetSceneRect( QRectF( 20, 130, 70, 70 ) );
  overviewMap->setFrameEnabled( true );
  overviewMap->setLayers( QList<QgsMapLayer *>() << mRasterLayer );
  l.addLayoutItem( overviewMap );
  map->setExtent( QgsRectangle( 96, -152, 160, -120 ) ); //zoom in
  overviewMap->setExtent( QgsRectangle( 0, -256, 256, 0 ) );
  overviewMap->overview()->setLinkedMap( map );

  QCOMPARE( overviewMap->overview()->linkedMap(), map );
  overviewMap->overview()->setLinkedMap( nullptr );
  QVERIFY( !overviewMap->overview()->linkedMap() );
  overviewMap->overview()->setLinkedMap( map );
  QCOMPARE( overviewMap->overview()->linkedMap(), map );
  overviewMap->overview()->setLinkedMap( nullptr );
  QVERIFY( !overviewMap->overview()->linkedMap() );

  //render
  overviewMap->overview()->setLinkedMap( map );
  QGSVERIFYLAYOUTCHECK( QStringLiteral( "composermap_overview" ), &l );
}

void TestQgsLayoutMapOverview::overviewMapRotated()
{
  QgsLayout l( QgsProject::instance() );
  l.initializeDefaults();
  QgsLayoutItemMap *map = new QgsLayoutItemMap( &l );
  map->attemptSetSceneRect( QRectF( 20, 20, 200, 100 ) );
  map->setFrameEnabled( true );
  map->setLayers( QList<QgsMapLayer *>() << mRasterLayer );
  l.addLayoutItem( map );

  QgsLayoutItemMap *overviewMap = new QgsLayoutItemMap( &l );
  overviewMap->attemptSetSceneRect( QRectF( 20, 130, 70, 70 ) );
  overviewMap->setFrameEnabled( true );
  overviewMap->setLayers( QList<QgsMapLayer *>() << mRasterLayer );
  l.addLayoutItem( overviewMap );
  map->setExtent( QgsRectangle( 96, -144, 160, -112 ) ); //zoom in
  map->setMapRotation( 30 );
  overviewMap->setExtent( QgsRectangle( 0, -256, 256, 0 ) );
  overviewMap->overview()->setLinkedMap( map );
  QGSVERIFYLAYOUTCHECK( QStringLiteral( "composermap_overview_rotated" ), &l, 0, 600 );
}

void TestQgsLayoutMapOverview::overviewMapRotated2()
{
  QgsLayout l( QgsProject::instance() );
  l.initializeDefaults();
  QgsLayoutItemMap *map = new QgsLayoutItemMap( &l );
  map->attemptSetSceneRect( QRectF( 20, 20, 200, 100 ) );
  map->setFrameEnabled( true );
  map->setLayers( QList<QgsMapLayer *>() << mRasterLayer );
  l.addLayoutItem( map );

  QgsLayoutItemMap *overviewMap = new QgsLayoutItemMap( &l );
  overviewMap->attemptSetSceneRect( QRectF( 20, 130, 70, 70 ) );
  overviewMap->setFrameEnabled( true );
  overviewMap->setLayers( QList<QgsMapLayer *>() << mRasterLayer );
  l.addLayoutItem( overviewMap );
  map->setExtent( QgsRectangle( 96, -152, 160, -120 ) ); //zoom in
  overviewMap->setMapRotation( 30 );
  overviewMap->setExtent( QgsRectangle( 0, -256, 256, 0 ) );
  overviewMap->overview()->setLinkedMap( map );
  QGSVERIFYLAYOUTCHECK( QStringLiteral( "composermap_overview_rotated2" ), &l, 0, 600 );
}

void TestQgsLayoutMapOverview::overviewMapBlending()
{
  QgsLayout l( QgsProject::instance() );
  l.initializeDefaults();
  QgsLayoutItemMap *map = new QgsLayoutItemMap( &l );
  map->attemptSetSceneRect( QRectF( 20, 20, 200, 100 ) );
  map->setFrameEnabled( true );
  map->setLayers( QList<QgsMapLayer *>() << mRasterLayer );
  l.addLayoutItem( map );

  QgsLayoutItemMap *overviewMapBlend = new QgsLayoutItemMap( &l );
  overviewMapBlend->attemptSetSceneRect( QRectF( 20, 130, 70, 70 ) );
  overviewMapBlend->setFrameEnabled( true );
  overviewMapBlend->setLayers( QList<QgsMapLayer *>() << mRasterLayer );
  l.addLayoutItem( overviewMapBlend );
  map->setExtent( QgsRectangle( 96, -152, 160, -120 ) ); //zoom in
  overviewMapBlend->setExtent( QgsRectangle( 0, -256, 256, 0 ) );
  overviewMapBlend->overview()->setLinkedMap( map );
  overviewMapBlend->overview()->setBlendMode( QPainter::CompositionMode_Multiply );

  QGSVERIFYLAYOUTCHECK( QStringLiteral( "composermap_overview_blending" ), &l );
}

void TestQgsLayoutMapOverview::overviewMapInvert()
{
  QgsLayout l( QgsProject::instance() );
  l.initializeDefaults();
  QgsLayoutItemMap *map = new QgsLayoutItemMap( &l );
  map->attemptSetSceneRect( QRectF( 20, 20, 200, 100 ) );
  map->setFrameEnabled( true );
  map->setLayers( QList<QgsMapLayer *>() << mRasterLayer );
  l.addLayoutItem( map );

  QgsLayoutItemMap *overviewMapInvert = new QgsLayoutItemMap( &l );
  overviewMapInvert->attemptSetSceneRect( QRectF( 20, 130, 70, 70 ) );
  overviewMapInvert->setFrameEnabled( true );
  overviewMapInvert->setLayers( QList<QgsMapLayer *>() << mRasterLayer );
  l.addLayoutItem( overviewMapInvert );
  map->setExtent( QgsRectangle( 96, -152, 160, -120 ) ); //zoom in
  overviewMapInvert->setExtent( QgsRectangle( 0, -256, 256, 0 ) );
  overviewMapInvert->overview()->setLinkedMap( map );
  overviewMapInvert->overview()->setInverted( true );

  QGSVERIFYLAYOUTCHECK( QStringLiteral( "composermap_overview_invert" ), &l );
}

void TestQgsLayoutMapOverview::overviewMapCenter()
{
  QgsLayout l( QgsProject::instance() );
  l.initializeDefaults();
  QgsLayoutItemMap *map = new QgsLayoutItemMap( &l );
  map->attemptSetSceneRect( QRectF( 20, 20, 200, 100 ) );
  map->setFrameEnabled( true );
  map->setLayers( QList<QgsMapLayer *>() << mRasterLayer );
  l.addLayoutItem( map );

  QgsLayoutItemMap *overviewMapCenter = new QgsLayoutItemMap( &l );
  overviewMapCenter->attemptSetSceneRect( QRectF( 20, 130, 70, 70 ) );
  overviewMapCenter->setFrameEnabled( true );
  overviewMapCenter->setLayers( QList<QgsMapLayer *>() << mRasterLayer );
  l.addLayoutItem( overviewMapCenter );
  map->setExtent( QgsRectangle( 192, -288, 320, -224 ) );
  overviewMapCenter->setExtent( QgsRectangle( 0, -256, 256, 0 ) );
  overviewMapCenter->overview()->setLinkedMap( map );
  overviewMapCenter->overview()->setCentered( true );

  QGSVERIFYLAYOUTCHECK( QStringLiteral( "composermap_overview_center" ), &l );
}

void TestQgsLayoutMapOverview::overviewReprojected()
{
  QgsLayout l( QgsProject::instance() );
  l.initializeDefaults();
  QgsLayoutItemMap *map = new QgsLayoutItemMap( &l );
  map->attemptSetSceneRect( QRectF( 20, 20, 200, 100 ) );
  map->setFrameEnabled( true );
  map->setLayers( QList<QgsMapLayer *>() << mRasterLayer );
  l.addLayoutItem( map );

  QgsLayoutItemMap *overviewMap = new QgsLayoutItemMap( &l );
  overviewMap->attemptSetSceneRect( QRectF( 20, 130, 70, 70 ) );
  overviewMap->setFrameEnabled( true );
  //overviewMap->setLayers( QList<QgsMapLayer *>() << mRasterLayer );
  l.addLayoutItem( overviewMap );

  map->setCrs( QgsCoordinateReferenceSystem::fromEpsgId( 4326 ) );
  overviewMap->setCrs( QgsCoordinateReferenceSystem::fromEpsgId( 54030 ) );

  map->setExtent( QgsRectangle( 93, -64.245, 120.6, -45 ) );
  overviewMap->setExtent( QgsRectangle( 4712502, -7620278, 10872777, -2531356 ) );
  overviewMap->overview()->setLinkedMap( map );

  QGSVERIFYLAYOUTCHECK( QStringLiteral( "composermap_overview_reprojected" ), &l );
}

QGSTEST_MAIN( TestQgsLayoutMapOverview )
#include "testqgslayoutmapoverview.moc"
