--
-- in-db 1 band float 32 raster
--
DROP TABLE IF EXISTS "public"."raster_sparse_3035" CASCADE;

CREATE TABLE "raster_sparse_3035"
(
  "rid"      serial PRIMARY KEY,
  "rast"     raster,
  "filename" text
);
INSERT INTO "raster_sparse_3035" ("rast", "filename")
VALUES ('0100000100000000000000394000000000000039C000000000D9204F41000000008F8B424100000000000000000000000000000000DB0B0000060005004A003C1CC66A610843880B0E431CC2194306342543B7633C43861858436E0A1143BBAD194359612743A12B334317BE4343DECE59432B621B43F0E42843132B3843AC824043E6CF48436E465A435C4D2D430FA63D43F87A4843B5494A4349454E4374F35B43906E41433AB54C43B056504358575243B1EC574322615F43'::raster,
        'raster_sparse_3035.tif');
CREATE INDEX ON "raster_sparse_3035" USING gist (st_convexhull("rast"));
ANALYZE "raster_sparse_3035";
SELECT AddRasterConstraints('', 'raster_sparse_3035', 'rast', TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, FALSE, TRUE, TRUE,
                            TRUE, TRUE, TRUE);

-- Make greater extent for data to make the raster sparse
ALTER TABLE raster_sparse_3035 DROP CONSTRAINT enforce_max_extent_rast;
ALTER TABLE IF EXISTS raster_sparse_3035
  ADD CONSTRAINT enforce_max_extent_rast CHECK (st_envelope(rast) @
  '0103000020DB0B0000010000000500000000000000D9204F4100000080508B42410000000063214F4100000080508B42410000000063214F4100000080C38B424100000000D9204F4100000080C38B424100000000D9204F4100000080508B4241'::geometry)
  NOT VALID;
