/***************************************************************************
 *   Copyright (C) 2003 by Tim Sutton                                      *
 *   tim@linfiniti.com                                                     *
 *                                                                         *
 *   This is a plugin generated from the QGIS plugin template              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef MAPCOORDSDIALOG_H
#define MAPCOORDSDIALOG_H

#include "ui_qgsmapcoordsdialogbase.h"

#include "qgscoordinatereferencesystem.h"
#include "qgsmapcanvas.h"
#include "qgsmaptoolemitpoint.h"
#include "qgspointlocator.h"
#include "qgspointxy.h"
#include "qgsprojectionselectionwidget.h"
#include "qgssnapindicator.h"
#include "qgssnappingutils.h"

#include <QDialog>

class QgsGeorefDataPoint;

class QPushButton;

class QgsGeorefMapToolEmitPoint : public QgsMapTool
{
    Q_OBJECT

  public:
    explicit QgsGeorefMapToolEmitPoint( QgsMapCanvas *canvas );

    void canvasMoveEvent( QgsMapMouseEvent *e ) override;

    void canvasPressEvent( QgsMapMouseEvent *e ) override;

    void canvasReleaseEvent( QgsMapMouseEvent *e ) override;

    void deactivate() override;

  signals:
    void canvasClicked( const QgsPointXY &point, Qt::MouseButton button );
    void mouseReleased();

  private:
    QgsPointLocator::Match mapPointMatch( QMouseEvent *e );

    std::unique_ptr<QgsSnapIndicator> mSnapIndicator;
};

class QgsMapCoordsDialog : public QDialog, private Ui::QgsMapCoordsDialogBase
{
    Q_OBJECT

  public:

    /**
     * Constructor for QgsMapCoordsDialog.
     * \param qgisCanvas
     * \param georefDataPoint Temporary data point used for preview on source and destination canvases while dialog is visible
     * \param rasterCrs
     * \param parent
     */
    QgsMapCoordsDialog( QgsMapCanvas *qgisCanvas, QgsGeorefDataPoint *georefDataPoint, QgsCoordinateReferenceSystem &rasterCrs, QWidget *parent = nullptr );
    ~QgsMapCoordsDialog() override;

    //! Update the source coordinates of the newly added
    void updateSourceCoordinates( const QgsPointXY &sourceCoordinates );

  private slots:
    void buttonBox_accepted();

    void setToolEmitPoint( bool isEnable );

    void maybeSetXY( const QgsPointXY &, Qt::MouseButton );
    void updateOK();
    void setPrevTool();

  signals:

    /**
     * Emitted when a point should be added through the dialog.
     * \param sourceCoordinate source point, which MUST be in source layer coordinates not pixels
     * \param destinationCoordinate
     * \param destinationCrs
     */
    void pointAdded( const QgsPointXY &sourceCoordinate, const QgsPointXY &destinationCoordinate, const QgsCoordinateReferenceSystem &destinationCrs );

  private:
    double dmsToDD( const QString &dms );

    QPushButton *mPointFromCanvasPushButton = nullptr;

    //QgsProjectionSelectionWidget *mProjSelect = nullptr;

    QgsGeorefMapToolEmitPoint *mToolEmitPoint = nullptr;
    QgsMapTool *mPrevMapTool = nullptr;
    QgsMapCanvas *mQgisCanvas = nullptr;

    QgsCoordinateReferenceSystem mRasterCrs;

    //! Used for point preview. Holds the source layer coordinates -- must be in source layer coordinates, not pixels (unless source image is completely non-referenced)
    QgsGeorefDataPoint *mNewlyAddedPoint = nullptr;
};

#endif
